<?php defined('PF_VERSION') OR exit('Access denied'); ?>
<?php
define('PLUGIN_GALLERY', __('Galleries', 'galleries'));
class Galleries_Plugin extends Pf_Plugin{
    public $name = PLUGIN_GALLERY;
    public $version = '1.0';
    public $author = 'PageFlex Team';
    public $description = 'This is the Galleries description';
    
    public function activate(){
    	$db = Pf::database();
    
    	$sql = "DROP TABLE IF EXISTS `pf_galleries`;";
    	$db->query($sql);
    
    	$sql = "CREATE TABLE `pf_galleries` (
                `id` int(11) NOT NULL AUTO_INCREMENT,
                `gallery_name` varchar(255) NOT NULL,
                `gallery_description` varchar(500) NOT NULL,
                `gallery_status` tinyint(4) NOT NULL,
                `gallery_data` longtext NOT NULL,
                `gallery_views` int(100) DEFAULT '0',
                PRIMARY KEY (`id`)
               ) ENGINE=InnoDB DEFAULT CHARSET=utf8";
    
    	$db->query($sql);
    }
    
    public function deactivate(){
    	$db = Pf::database();
    	$sql = "DROP TABLE IF EXISTS `pf_galleries`;";
    
    	$db->query($sql);
    }

    public function admin_init(){
        if(is_admin() or is_editor() or is_author())
        $this->admin_menu('fa fa-camera', __('Galleries', 'galleries'), 'galleries', 'galleries' );
    }
    public function public_init(){
        $shortcode = Pf::shortcode();
        $shortcode->add( 'gallery', array($this,'public_gallery' ));
    }
    
    function public_gallery( $atts, $content = null, $code = '' ){
       $catid  =   !empty($_GET['gallery'])?$_GET['gallery']:'';
       if(empty($catid)){$catid =   !empty($atts['cat'])?$atts['cat']:'';}
        ob_start();
        require_once abs_plugin_path(__FILE__) . "/galleries/public/gallery-public.php";
        $content = ob_get_contents();
        ob_end_clean();
        return $content;
    }

    public function galleries(){
        
        $ref=array('admin-page'=>'galleries');
        if(!empty($_GET['page'])) $ref['page']  =   $_GET['page'];
        if(!empty($_GET['galleryname'])) $ref['galleryname']    =   $_GET['galleryname'];
        if(!empty($_GET['publish'])) $ref['publish']    =   $_GET['publish'];
        if(is_admin() or is_editor() or is_author()){
        $actions = array('create', 'edit', 'list');
        $action = (isset($_GET['action']) && in_array($_GET['action'], $actions) == true) ? $_GET['action'] : 'list';
        $this->js('admin/plugins/media/assets/fancybox/jquery.fancybox-1.3.6.pack.js');
        $this->css('admin/plugins/media/assets/fancybox/jquery.fancybox-1.3.6.css');
        $this->css('plugins/galleries/assets/galleries.css');
        $this->js('galleries/assets/galleries.js',__FILE__);
        $this->css('admin/themes/default/assets/bootstrap-modal/css/animate.min.css');
        $this->js('admin/themes/default/assets/bootstrap-modal/js/bootstrap.modal.js');
        $this->js ( 'admin/themes/default/assets/bootstrap-notification/js/bootstrap.notification.js' );
        require abs_plugin_path(__FILE__) . '/galleries/class/galleries-class.php';
        require abs_plugin_path(__FILE__) . '/galleries/actions/'.$action.'.php';
        }
        else
            exit ();
    }

}